<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->enum('return_status', ['none', 'returned'])->default('none')->after('payment_status');
            $table->timestamp('returned_at')->nullable()->after('return_status');
            $table->text('return_reason')->nullable()->after('returned_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn(['return_status', 'returned_at', 'return_reason']);
        });
    }
};
